#!/bin/bash

if [ "$(whoami)" == "root" ]; then
  export DESTINATION=/usr/local/bin/linux_bin
else
  export DESTINATION=$HOME/bin/linux_bin
fi
mkdir -p $DESTINATION
cp -p get_folder.sh $DESTINATION
cd $DESTINATION
# run a "runme" helper script so that the current get_folder.sh may be overwritten by the new one:
grep -v runme ./get_folder.sh > ./get_folder.sh.runme
chmod +x ./get_folder.sh.runme
exec ./get_folder.sh.runme && exit

wget --no-check-certificate -O- https://wiki.uni-konstanz.de/pub/linux_bin/xds_extra_linux.tar | tar xjvf -

# alternative names:
ln -s XDS-viewer xdsviewer
ln -s XDS-viewer xds-viewer
cd ..
ln -sf linux_bin/* .
# remove some symlinks:
rm -f README.* dectris-neggia.so durin-plugin.so xds-zcbf.so
echo check Unix tools that generate_XDS.INP may need -
for i in  ls grep egrep awk cut cat echo wc bc head sed tail cp od python strings h5dump ; do 
 which $i >& /dev/null || echo $i not found
 done
echo all done

# delete the get_folder.sh.runme script after it has done its work
rm -- "$0"

