#!/bin/bash
# script for copying files from mac_bin directory on wiki.uni-konstanz.de server to client Mac
# this was tested and works on Catalina and Big Sur for Intel Macs
# for Silicon Macs, use get_folder_Silicon.sh

# run a "runme" helper script so that the current get_folder.sh can be overwritten by the new one:
grep -v runme ./get_folder.sh > ./get_folder.sh.runme
chmod +x ./get_folder.sh.runme
exec ./get_folder.sh.runme && exit

# check if we are root
if [ "$(id -u)" != "0" ]; then
  echo you must run   sudo su   before running this script!
  exit 1
fi 

# copy files from server
  curl -o - https://wiki.uni-konstanz.de/pub/mac_bin/xds_extra_mac.tar | tar xzvf -

# install Neggia library for Eiger processing
if [ ! -f /usr/local/lib64/dectris-neggia.so ]; then 
  mkdir -p /usr/local/lib64/
  cp -p dectris-neggia.so /usr/local/lib64/
  chmod a+rx /usr/local/lib64/dectris-neggia.so
fi
# install Durin library for Eiger data from DLS
if [ ! -f /usr/local/lib64/durin-plugin.so ]; then
  mkdir -p /usr/local/lib64/
  cp -p durin-plugin.so /usr/local/lib64/
  chmod a+rx /usr/local/lib64/durin-plugin.so
fi


# copy files to /usr/local/bin
chmod a+rx ./*
[ -e /usr/local/bin ] || mkdir -p /usr/local/bin
rsync -a h5dump eiger2cbf hdf2mini-cbf generate_XDS.INP spot2pdb xdscc12 xds_nonisomorphism xdsstat xscale_isocluster /usr/local/bin
rsync -a hdf2mini-cbf /usr/local/bin/H5ToXds

rm -f xdsgui.dmg
echo installing XDSGUI and XDS-viewer:
hdiutil attach -mountpoint mountpoint xdsgui_mac_intel.dmg
rsync -a --delete mountpoint/xdsgui.app /Applications
hdiutil detach mountpoint

hdiutil attach -mountpoint mountpoint XDS-Viewer-macOS10.13.dmg
rsync -a --delete mountpoint/XDS-Viewer.app /Applications
hdiutil detach mountpoint

hdiutil attach -mountpoint mountpoint xxdiff-4.0b1.osx.dmg
rsync -a --delete mountpoint/xxdiff.app /Applications
hdiutil detach mountpoint

ln -sf /Applications/xdsgui.app/Contents/MacOS/xdsgui /usr/local/bin/xdsgui
ln -sf /Applications/XDS-Viewer.app/Contents/MacOS/XDS-Viewer /usr/local/bin/xds-viewer
ln -sf /Applications/xxdiff.app/Contents/MacOS/xxdiff /usr/local/bin/xxdiff

# check CCP4, and setup if necessary
# 1. assumption: the setup script is at /Applications/ccp4-XXX/bin/ccp4.setup-sh
# 2. assumption: the zsh is used by everyone
which refmac5 >& /dev/null
if [ $? -eq 0 ]; then
  echo "CCP4 appears to be properly installed for XDSGUI and XDSCONV usage"
else
  echo "CCP4 is not installed for commandline usage, but this is needed by XDSCONV, pointless and coot when called from XDSGUI"
  if [ -e /Applications/ccp4-8.0 ]; then
    export ccp4ver="ccp4-8.0"
  fi
  if [ -e /Applications/ccp4-9 ]; then
    export ccp4ver="ccp4-9"
  fi
  if [ ! -e /Applications/$ccp4ver/bin/ccp4.setup-sh ]; then
    echo "could not find CCP4 setup script in /Applications/$ccp4ver/bin/ccp4.setup-sh"
  else
    if [ "$(whoami)" != 'root' ]; then
      echo "source /Applications/$ccp4ver/bin/ccp4.setup-sh" >> ~/.zprofile
      echo "setting up $ccp4ver in ~/.zprofile for commandline usage"
    else
      echo "source /Applications/$ccp4ver/bin/ccp4.setup-sh" >> /etc/zprofile
      echo "setting up $ccp4ver in /etc/zprofile for commandline usage of all users"
    fi
  fi
fi

# delete the get_folder.sh.runme script after it has done its work
rm -- "$0"
